<?php
/**
* The template for displaying archive and categories - www.planet-www.com.
*/
get_header(); ?>
<div id="content" class="container-fluid">
	<div class="row">
		<?php get_sidebar(); ?>
		<div class="col-md-9">
			<?php if ( have_posts() ) : ?>
			<div class="cat-head">
				<?php
				the_archive_title( '<h1 class="cat-title">', '</h1>' );
				the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
			</div>
			<div class="row">
				<?php while ( have_posts() ) : the_post(); ?>
				<div class="col-md-6 col-sm-6 text-center pwww">
					<div class="cat">
					    <div class="txt-h text-center pwww">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
								<?php the_title('<h3>','</h3>'); ?>
							</a>
						</div>
						<div class="img-www">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
								<?php the_post_thumbnail( 'my-thumb' );?>
							</a>
						</div>
						<div class="txt-www text-left pwww">
							<?php the_excerpt(); ?>
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="txt-m pwww">اقرأ المزيد</a>
						</div>
					</div><!-- PWWW /.cat -->
				</div>
				<?php endwhile; ?>
			</div>
			<?php the_posts_pagination( array(
			'mid_size' => 2,
			'prev_text' => __( '<', 'textdomain' ),
			'next_text' => __( '>', 'textdomain' ),
			'screen_reader_text' => __( ' ', 'textdomain' ),
			) ); 
			?>
			<?php else : ?>
			<?php endif; ?>
		</div>
	</div>
</div><!-- #content -->
<?php get_footer(); ?>