<?php
 // Planet WWW CONTACT FORM Widget 
class pwww_cats extends WP_Widget {
function __construct() {
	parent::__construct(
	// Base ID
	'pwww_cats',
	// Widget name will appear in UI
	__('Planet WWW Categories', 'wpb_widget_domain'), 
	// Widget description
	array( 'description' => __( 'Widget for Contact Form from PWWW', 'wpb_widget_domain' ), ) 
	);
}
// Widget front-end
public function widget( $args, $instance ) {
$title = apply_filters( 'widget_title', $instance['title'] );
// before and after widget arguments are defined by themes
echo $args['before_widget'];
if ( ! empty( $title ) )
echo $args['before_title'] . $title . $args['after_title'];
// PWWW NAME ------------------------------------------------------------------------------------
?>
<ul>
<?php
add_filter ( 'wp_list_categories', 'pwww_sub_cat' );
function pwww_sub_cat( $list ) {
$list = str_replace('<a href=','<span class="sub-arr"></span><a href=',$list);
return $list;
}
 $dia = wp_list_categories('echo=0&exclude=4&title_li=&orderby=count&show_count=1');
 $dia = str_replace(array('(',')'), array('<span class="cat-num">','</span>'), $dia);
 echo $dia;
?>
</ul>
<?php
// End PWWW NAME --------------------------------------------------------------------------------
echo __( '', 'wpb_widget_domain' );
echo $args['after_widget'];
}
// Widget Backend 
public function form( $instance ) {
if ( isset( $instance[ 'title' ] ) ) {
$title = $instance[ 'title' ];
}
else {
$title = __( 'PWWW CATS', 'wpb_widget_domain' );
}
// Widget admin form
?>
<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<?php 
}
	
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
$instance = array();
$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
return $instance;
}
} // Class pwww_cf ends here

// Register and load the widget
function pwww_cats() {
	register_widget( 'pwww_cats' );
}
add_action( 'widgets_init', 'pwww_cats' );