<?php
/**
 * The template for displaying the header - www.planet-www.com.
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php wp_title('&raquo;','true','right'); ?><?php bloginfo('name'); ?></title>
	<meta http-equiv="cache-control" content="max-age=0" />
	<meta http-equiv="cache-control" content="no-cache" />
	<meta name="viewport" content="width=device-width" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
	<link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" />
	<link rel="stylesheet" type="text/css" media="all" href="<?php echo get_template_directory_uri(); ?>/css/jquery.fancybox.css" />
	<link rel="stylesheet" type="text/css" media="all" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/jquery.fullPage.css" />
	<link type="text/css" rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/style.css?v=1.05" media="all" />
	<style>
    .section{text-align:center;}
    #section0 {background: url('<?php echo esc_attr( get_option('bgi1') ); ?>') center center fixed;background-size: cover;}
    #section1 {background: url('<?php echo esc_attr( get_option('bgi2') ); ?>') center center fixed;background-size: cover;}
    #section2 {background: url('<?php echo esc_attr( get_option('bgi0') ); ?>') center center fixed;background-size: cover;}
    #section3 {background: url('<?php echo esc_attr( get_option('bgi3') ); ?>') center center fixed;background-size: cover;}
    #section4 {background: url('<?php echo esc_attr( get_option('bgi4') ); ?>') center center fixed;background-size: cover;}
    #section5 {background: url('<?php echo esc_attr( get_option('bgi5') ); ?>') center center fixed;background-size: cover;}
    #section6 {background: url('<?php echo esc_attr( get_option('bgi6') ); ?>') center center fixed;background-size: cover;}
    #section7 {background: url('<?php echo esc_attr( get_option('bgi7') ); ?>') center center fixed;background-size: cover;}
    </style>
	<!--[if lt IE 9]>
	<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
	<![endif]-->
	<script src="https://code.jquery.com/jquery-latest.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.fancybox.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/pwww.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.fullPage.js"></script>
    <script>
        $(document).ready(function() {
            $('#fullpage').fullpage({
                sectionsColor: ['#ffffff', '#ffffff', '#ccddff', '#4BBFC3', '#7ca82d', '#ccddff', '#ccddff'],
                anchors: ['about', 'products',  'services', 'membership', 'shipments', 'gallery','contact'],
                menu: '#menu-main-nav',slidesNavigation: true,responsiveHeight: 600,css3:false,
                afterRender: function () {
                    setInterval(function() {
                        $.fn.fullpage.moveSlideRight();
                    }, 10000);
                },
                onSlideLeave: function(anchorLink, index, slideIndex, direction) {
                    //$('.main-slider').hide();
                    $('#imgd').hide();
                },
                afterSlideLoad: function(anchorLink, index, slideAnchor, slideIndex) {
                    //$('.main-slider').fadeIn();
                    $('#imgd').fadeIn(1500);
                },
            });
            $('#imgd').fadeIn(1500);
        });
    </script>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="fullpage">
<nav class="navbar navbar-default navbar-fixed-top" data-role="navigation">
    <div class="container-fluid">
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <a class="navbar-brand" href="<?php echo home_url(); ?>">
                MEDITFERT
            </a>
        </div>
        <?php
        wp_nav_menu( array(
        'menu'              => 'primary',
        'theme_location'    => 'primary',
        'depth'             => 2,
        'container'         => 'div',
        'container_class'   => 'collapse navbar-collapse',
        'container_id'      => 'bs-example-navbar-collapse-1',
        'menu_class'        => 'nav navbar-nav',
        'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
        'walker'            => new wp_bootstrap_navwalker())
        );
        ?>
    </div>
</nav><!-- PWWW /nav -->