<?php
/**
 * The main template file - www.planet-www.com.
 */
get_header(); ?>
	<?php if ( have_posts() ) : ?>
		<?php if ( is_home() && ! is_front_page() ) : ?>
			<div>
				<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
			</div>
		<?php endif; ?>
		<?php
		// Start the loop.
		while ( have_posts() ) : the_post();
			the_title();
			the_content();
		// End the loop.
		endwhile;
		// Previous/next page navigation.
		the_posts_pagination( array(
			'prev_text'          => __( 'Previous page', 'arbaelogyo' ),
			'next_text'          => __( 'Next page', 'arbaelogyo' ),
			'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'arbaelogyo' ) . ' </span>',
		) );
	// If no content, include the "No posts found" template.
	else :
		get_template_part( 'content', 'none' );
	endif;
	?>
<?php get_footer(); ?>