<?php
/**
* The template for displaying Search Results pages - www.planet-www.com.
*
*/
get_header(); ?>
<div id="content" class="container">
	<div class="row">
		<?php get_sidebar(); ?>
		<div class="col-md-9">
			<?php if ( have_posts() ) : ?>
			<div class="sh-header">
				<h1 class="page-head">
					<?php printf( __( 'البحث عن : %s', 'shape' ), '<span>' . get_search_query() . '</span>' ); ?>
				</h1>
			</div><!-- .sh-header -->
			<?php while ( have_posts() ) : the_post(); ?>
			<div class="row rezz bg2">
				<div class="col-md-3 col-sm-3">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail( 'thumbnail' );?>
					</a>
				</div>
				<div class="col-md-9 col-sm-9">
					<div>
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
							<?php the_title('<h3>','</h3>'); ?>
						</a>
						<?php the_excerpt(); ?>
					</div>
				</div>
			</div><!-- PWWW /.rezz -->
			<?php endwhile; ?>
			<?php the_posts_pagination( array(
			'mid_size' => 2,
			'prev_text' => __( '<', 'textdomain' ),
			'next_text' => __( '>', 'textdomain' ),
			'screen_reader_text' => __( ' ', 'textdomain' ),
			) ); 
			?>	  
			<?php else : ?>
			<h2>نتيجة البحث</h2>
			<hr class="h-2r" />
			<p>لا توجد نتائج مطابقة لبحثك</p>
			<?php endif; ?>
		</div>
	</div>
</div><!-- #content -->
<?php get_footer(); ?>